/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ProcessRunner;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class URIUtil {
    private URIUtil() {
    }

    public static String decodeURI(String uri) {
        String result = null;
        if (uri != null) {
            try {
                result = URLDecoder.decode(uri, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean open(URI uri) {
        if (uri == null) {
            return false;
        }
        if (!"file".equalsIgnoreCase(uri.getScheme())) {
            return false;
        }
        File file = new File(uri);
        if (Platform.getOS().equals("macosx")) {
            return URIUtil.openInFinder(file);
        }
        if (Platform.getOS().equals("win32")) {
            return URIUtil.openInWindowsExplorer(file);
        }
        return URIUtil.openOnLinux(file);
    }

    private static boolean openOnLinux(File file) {
        IStatus result;
        if (file.isFile()) {
            file = file.getParentFile();
        }
        if ((result = new ProcessRunner().runInBackground("nautilus", file.getAbsolutePath())) == null) {
            return false;
        }
        return result.isOK();
    }

    private static boolean openInWindowsExplorer(File file) {
        String explorer = PlatformUtil.expandEnvironmentStrings("%SystemRoot%\\explorer.exe");
        try {
            Process p = Runtime.getRuntime().exec("\"" + explorer + "\" /select,\"" + file.getAbsolutePath() + "\"");
            return p.exitValue() == 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean openInFinder(File file) {
        return URIUtil.openInFinder(file, file.isFile());
    }

    public static boolean openInFinder(File file, boolean reveal) {
        String path = file.getAbsolutePath();
        String subcommand = reveal ? "reveal" : "open";
        String appleScript = "tell application \"Finder\" to " + subcommand + " (POSIX file \"" + path + "\")\ntell application \"Finder\" to activate";
        IStatus result = new ProcessRunner().runInBackground("osascript", "-e", appleScript);
        return result != null && result.isOK();
    }

    public static String getFileName(URI uri) {
        if (uri == null) {
            return null;
        }
        String uriPath = uri.getPath();
        IPath path = Path.fromPortableString((String)uriPath);
        if (path == null) {
            return null;
        }
        return path.lastSegment();
    }
}

